<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

include "config.php"; // your DB connection

$data = json_decode(file_get_contents("php://input"), true);

$email = $data['email'] ?? '';
$password = $data['password'] ?? '';

if (!$email || !$password) {
    echo json_encode(["success" => false, "message" => "Missing fields"]);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM loginusers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if ($user && password_verify($password, $user['password'])) {
    session_start();
    $_SESSION['clogin'] = $user['email']; // ✅ save session
    echo json_encode([
        "success" => true,
        "message" => "Login successful",
        "user" => [
    "id" => $user['id'],
    "email" => $user['email'],
    "first_name" => $user['first_name'],
    "last_name" => $user['last_name']
]

    ]);
} else {
    echo json_encode(["success" => false, "message" => "Invalid credentials"]);
}
