<?php
include 'config.php';

$limit = 10; // Records per page
$page = isset($_POST['page']) ? $_POST['page'] : 1;
$start = ($page - 1) * $limit;

$search = '';
if (isset($_POST['query'])) {
    $search = $_POST['query'];
}

$sql = "SELECT * FROM aspnetusers WHERE fullname LIKE :search OR email LIKE :search OR country LIKE :search OR number LIKE :search ORDER BY id DESC LIMIT :start, :limit";
$query = $dbh->prepare($sql);
$likeSearch = "%$search%";
$query->bindParam(':search', $likeSearch, PDO::PARAM_STR);
$query->bindParam(':start', $start, PDO::PARAM_INT);
$query->bindParam(':limit', $limit, PDO::PARAM_INT);
$query->execute();
$results = $query->fetchAll(PDO::FETCH_OBJ);

?>

<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Country</th>
            <th>Number</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php if ($query->rowCount() > 0): ?>
            <?php foreach ($results as $result): ?>
                <tr>
                    <td><?php echo htmlentities($result->fullname); ?></td>
                    <td><?php echo htmlentities($result->email); ?></td>
                    <td><?php echo htmlentities($result->country); ?></td>
                    <td><?php echo htmlentities($result->number); ?></td>
                    <td>
                        <?php if ($result->email_confirmed == 1): ?>
                            <span style="color: green;">Active</span>
                        <?php else: ?>
                            <span style="color: red;">Inactive</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="view_client.php?email=<?php echo htmlentities($result->email); ?>" class="btn btn-success btn-sm">View</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="6" style="text-align:center;">No users found</td></tr>
        <?php endif; ?>
    </tbody>
</table>
